Ext.define('Photoalbum.controller.App', {
    extend : 'Ext.app.Controller',

    models : [												//Will prepend 'Photoalbum.model' to this string
        'Image',
        'Picasa'
    ],

    stores : [												//Will prepend 'Photoalbum.store' to this string and create an instance
        'Images'
    ],

    views : [												//Will prepend 'Photoalbum.view' to these strings
        'Table',
        'Detail',
        'DetailInfo',
        'DetailComments',
        'DetailMap'
    ],

    /**
     * refs will create a getter method for each ref. This will hold a single instance using the selector
     * which is an Ext.ComponentQuery string selector
     */
    refs : [
        {
            ref      : 'mainview',                          //Will create a getter method on the controller getViewport, notice case
            selector : '#mainview'
        },
        {
            ref      : 'table',
            selector : 'photoalbum-table'
        },
        {
            ref      : 'detail',
            selector : 'photoalbum-detail'
        },
        {
            ref      : 'detailInfo',
            selector : 'photoalbum-detail-info'
        },
        {
            ref      : 'detailComments',
            selector : 'photoalbum-detail-comments'
        },
        {
            ref      : 'detailMap',
            selector : 'photoalbum-detail-map'
        }
    ],

    init: function() {
    	console.log('controller init');
        this.control({
        	'photoalbum-table': {
                itemtap: 'handleItemTap',
                itemtaphold: 'handleItemTapHold'
            },
            'photoalbum-detail'	: {
            	show: 'handleDetailShow',
            	hide: 'handleDetailHide',
            },
            'photoalbum-detail #delpic'	: {
            	tap: 'deletePicture'
            },
            'photoalbum-detail tabpanel': {
            	activeitemchange: 'handleDetailTabChange'
            },
            'photoalbum-detail-info #record': {
            	tap: 'recordAudio'
            },
            'photoalbum-detail-info #delaudio': {
            	tap: 'deleteAudio'
            },
            'photoalbum-detail-info #description': {
            	change: 'changeDescription'
            },
            'photoalbum-detail-info #taglist': {
            	disclose: 'deleteTag'
            },
            'photoalbum-detail-info #addtag': {
            	tap: 'addTag'
            },
            'photoalbum-detail-comments #addcomment': {
            	tap: 'addComment'
            },
            'photoalbum-detail-map #locate': {
            	tap: 'changeLocation'
            },
            '#mainview #photoselect': {
            	tap: 'selectPhoto'
            },
            '#mainview #mailshare': {
            	tap: 'composeShareMail'
            },
            '#mainview #refresh': {
            	tap: function() {navigator.app.loadUrl(window.location.href);}
            },
            '#mainview #zoomreset': {
            	tap: 'resetZoom'
            }
        });
    },
    
    launch: function() {
    	console.log('controller launch');
    	this.getMainview().add({xtype: 'photoalbum-table'});
    	this.getTable().setStore(this.getImagesStore());
    	this.getMainview().getScrollable().getScroller().scrollTo(1500,2000);
    	this.getTable().getStore().on('beforeload', function() {
    		this.getMainview().getParent().setMask({message: ' '});
    		setTimeout("Ext.getCmp('detail').mapload()",5000);
    	}, this);
    	this.getTable().getStore().on('add', this.handleStoreAdd, this);
    	this.getTable().getStore().on('load', this.handleStoreLoad, this);
    	this.getTable().getStore().load();
    },
    
    handleStoreAdd: function(store, records, eOpts ) {
    	Ext.Array.each(records, function(item, index, array) {
    		var priority = store.getPriority(item);
			item.picasa().getAt(0).resize(priority+1);
    	});
    	Ext.Array.each(records, function(item, index, array) {
    		item.save();
    	});
    	this.getMainview().getParent().setMask({xtype: 'mask'}); // Before unmasking the viewport make sure that the loading mask is not shown
    	this.getMainview().getParent().unmask();
    },
    
    handleStoreLoad: function(store, records, successful, operation, eOpts) {
        Ext.util.JSONP.request({
            url: server+'read.php',
            callbackKey: 'callback',
            params: {
                username: username,
                password: password,
                last: getLastLogin()
            },

            callback: function(result) {
            	window.localStorage.setItem("login", Ext.Date.format(new Date(), 'c'), 365);
            	var newImages = Array();
            	for(var i=0; i<result.length; i++) {
            		var updated = false;
            		// Look for old records and update picasa
            		for(var j=0; j<records.length; j++) {
            			if(records[j].get('picasaid') == result[i].id) {
            				records[j].picasa().removeAll();
            				records[j].picasa().add(result[i]);
            				records[j].picasa().sync();
            				newImages.push(records[j]);
            				updated = true;
            			}
            		}
            		// Add new images from picasa
            		if(!updated) {
            			var bounds = getGridBounds([0,0,result[i].width,result[i].height]);
            			var availables = getAvailableGrid(bounds,spawnGrid);
            			if(availables.length>0) {
	            			var rand = Math.floor(Math.random()*availables.length);
	            			bounds[0] = availables[rand][0];
	            			bounds[1] = availables[rand][1];
	            			var newImage = Ext.create('Photoalbum.model.Image', {'picasaid': result[i].id, 'top': ((bounds[1]*150)+300),'left': ((bounds[0]*150)+300)});
	            			var imagePicasa = newImage.picasa();
	                		imagePicasa.add(result[i]);
	                		imagePicasa.sync();
	                		newImages.push(newImage);
	                		spawnGrid = setAvailableGrid(bounds,spawnGrid,false);
            			}
            		}
            		/*Get uiserid and pseudo albumlist from server
            		Ext.util.JSONP.request({
                        url: server+'share.php',
                        callbackKey: 'callback',
                        params: {
                            username: username,
                            password: password,
                            albumname: 'Photoalbum'
                        },

                        callback: function(result) {
                        	userid = result.userid;
                        	albumlist = result.albumlist;
                        }
                	});/**/
            	}
            	// Replace the store data
            	store.removeAll();
            	store.add(newImages);
            }
        });
    },
    
    istaphold: false,
    previous: false,

    handleItemTap: function(dataview,index,target) {
    	if(!this.istaphold) {
	    	this.getDetail().showBy({element: target.child('*')});
	    	this.previous = this.select(dataview,index);
    	} else this.istaphold=false;
    },
    
    handleItemTapHold: function(dataview,index,target) {
    	this.istaphold=true;
    	var eventpos, 
    		elembounds=dataview.getStore().getAt(index).getBounds();
    	if(target.child('*',true).style.backgroundColor!="red") {
    		this.previous = this.select(dataview,index);
    		// View gridmask
    		target.child('*',true).style.backgroundColor="red !important";
    		target.child('*',true).style.zIndex="102";
    		dataview.setMask({
    			xtype: 'mask',
    			cls: 'gridmask'
    		});
    		this.getMainview().getScrollable().getScroller().setDisabled(true);
    		// Drag and drop
    		target.child('*').on({
    			dragstart: function(event) {
    				eventpos = [event.pageX,event.pageY];
    				var bounds = getGridBounds(elembounds);
    				spawnGrid = setAvailableGrid(bounds,spawnGrid,true);
    			},
    			drag: function(event) {
    				target.child('*').setLeft(elembounds[0]+event.pageX-eventpos[0]);
    				target.child('*').setTop(elembounds[1]+event.pageY-eventpos[1]);
    			},
    			// Update spawnGrid
    			dragend: function() {
    				var bounds = getGridBounds([target.child('*').getLeft(),target.child('*').getTop(),
    				                            elembounds[2],elembounds[3]]);
    				var closest = getClosestAvailable(bounds,spawnGrid);
    				if(closest && closest.length==2) {
    					bounds[0]=closest[0]; bounds[1]=closest[1];
    					spawnGrid = setAvailableGrid(bounds,spawnGrid,false);
    					elembounds[0] = (bounds[0]*150)+300;
    					elembounds[1] = (bounds[1]*150)+300;
    					target.child('*').setLeft(elembounds[0]);
    					target.child('*').setTop(elembounds[1]);
    				}
    			}
    		});
    	} else {
    		elembounds[0]=target.child('*').getLeft();
        	elembounds[1]=target.child('*').getTop();
    		// Update store, reactivate scroller, hide gridmask
    		dataview.getSelection()[0].set('left',elembounds[0]);
    		dataview.getSelection()[0].set('top',elembounds[1]);
    		dataview.getSelection()[0].save();
    		target.child('*',true).style.backgroundColor="black";
    		target.child('*',true).style.zIndex="auto";
    		target.child('*').clearListeners();
    		this.getMainview().getScrollable().getScroller().setDisabled(false);
    		dataview.unmask();
    	}
    },
    
    select: function(dataview,index) {
    	dataview.select(index,false,false);
    	var selected = dataview.getSelection()[0]; 
    	selected.set('clicks',selected.get('clicks')+1);
    	if(this.previous!=false && this.previous!=selected.get('id')) {
    		var prev = dataview.getStore().getById(this.previous);
    		prev.addAffinity(selected.get('id'));
    		selected.addAffinity(this.previous);
	    	var priority = dataview.getStore().getPriority(prev);
	    	var picasa = prev.picasa();
	    	picasa.getAt(0).resize(priority+1);
	    	prev.set('click',prev.get('click')); //This is a trick to update prev
	    	var bounds = getGridBounds(prev.getBounds());
			spawnGrid = setAvailableGrid(bounds,spawnGrid,false);
			prev.save();
    	}
    	return selected.get('id');
    },
    
    handleDetailHide: function() {
    	this.getDetail().hideAffinityTab();
    	// Update Store
    	if(!this.getDetail().loadingmask && this.getTable().getSelection().length>0) {
	    	var selected = this.getTable().getSelection()[0].picasa().getAt(0);
    		var params = new Object();
    		params.empty = true;
    		
	    	if(selected.tagupdate) {
	    		var tags = "";
	    		this.getDetailInfo().down('#taglist').getStore().each(function(record) {
	    			tags = tags + record.get('name') +",";
	    		});
	    		params.taglist = tags.substr(0,tags.length-1);
	    		params.empty = false;
	    	} if(selected.summaryupdate) {
	    		params.summary = selected.get('summary');
	    		params.empty = false;
	    	} if(selected.commentupdate != false) {
	    		params.comment = selected.commentupdate;
	    		params.empty = false;
	    	} if(selected.locationupdate != false) {
	    		params.location = selected.locationupdate;
	    		params.empty = false;
	    	}
	    	
	    	if(!params.empty) {
	    		params.username = username;
	    		params.password = password;
	    		params.photoid = selected.get('id');
	    		Ext.util.JSONP.request({
	                url: server+'update.php',
	                callbackKey: 'callback',
	                params: params,
	                callback: function() {
	                	selected.tagupdate = false;
	                	selected.summaryupdate = false;
	                	selected.commentupdate = false;
	                	selected.locationupdate = false;
	                }
	        	});
	    	}
	    	
	    	this.getTable().getSelection()[0].save();
    	}
    },
    
    handleDetailShow: function() {
    	var affinity = this.getTable().getSelection()[0].getSortedAffinity(5);
    	if(affinity.length>0) {
	    	for(var i=0; i<affinity.length; i++) {
	    		affinity[i] = this.getTable().getStore().getById(affinity[i][0]).picasa().getAt(0).get('url');
	    	}
	    	this.getDetail().showAffinityTab(affinity);
    	}
    	this.getDetailComments().initialized = false;
    	this.getDetailComments().removeAll(true,true);
    	this.getDetailInfo().initialized = false;
    	this.getDetailInfo().removeAll(true,true);
    	this.getDetailMap().initialized = false;
    	this.getDetail().loadingmask = true;
    	var activeItem = this.getDetail().child('tabpanel').getActiveItem();
//    	activeItem.element.dom.style.visibility="";
    	if(activeItem == this.getDetailInfo())
    		this.showDetailInfo();
    	else if(activeItem == this.getDetailComments())
    		this.showDetailComments();
    	else if(activeItem == this.getDetailMap())
    		this.showDetailMap();
    },
    
    handleDetailTabChange: function(container, newTab, oldTab, eOpts) {
    	if(oldTab==this.getDetailInfo())
    		this.getDetailInfo().initialized = true;
    	if(oldTab==this.getDetailComments())
    		this.getDetailComments().initialized = true;
    	if(oldTab==this.getDetailMap())
    		this.getDetailMap().initialized = true;
    	if(newTab==this.getDetailInfo() && !this.getDetailInfo().initialized)
    		this.showDetailInfo();
    	if(newTab==this.getDetailComments() && !this.getDetailComments().initialized)
    		this.showDetailComments();
    	if(newTab==this.getDetailMap() && !this.getDetailMap().initialized)
    		this.showDetailMap();
//    	oldTab.element.dom.style.display="none !important";
//    	oldTab.element.dom.style.visibility="";
//    	newTab.element.dom.style.display="";
//    	setTimeout("Ext.getCmp('detail').child('tabpanel').getActiveItem().element.dom.style.visibility='visible !important';",1000);
    },

    showDetailInfo: function() {
    	this.getDetailInfo().setMask({message: ' '});
    	//If audio description is available, show audio description
    	if(this.getTable().getSelection()[0].picasa().getAt(0).get('audio')!='') {
	    	this.getDetailInfo().bindAudio(this.getTable().getSelection()[0].picasa().getAt(0).get('audio'));
    	//If no audio is available, show text description
    	} else {
    		this.getDetailInfo().bindDescription(this.getTable().getSelection()[0].picasa().getAt(0).get('description'));
    	}
    	//Retrieve tags for the image
    	Ext.util.JSONP.request({
            url: server+'tags.php',
            callbackKey: 'callback',
            params: {
                username: username,
                password: password,
                photoid: this.getTable().getSelection()[0].picasa().getAt(0).get('id')
            },

            callback: function(result) {
            	Ext.getCmp('detailinfo').bindTags(result);
            	Ext.getCmp('detailinfo').setMask(false);
            	Ext.getCmp('detail').loadingmask = false;
            }
    	});
    },
    
    showDetailComments: function() {
    	this.getDetailComments().setMask({message: ' '});
    	//Retrieve comments for the image
    	Ext.util.JSONP.request({
            url: server+'comments.php',
            callbackKey: 'callback',
            params: {
                username: username,
                password: password,
                photoid: this.getTable().getSelection()[0].picasa().getAt(0).get('id')
            },

            callback: function(result) {
            	Ext.getCmp('detailcomments').bindComments(result);
            	Ext.getCmp('detailcomments').setMask(false);
            	Ext.getCmp('detail').loadingmask = false;
            	Ext.getCmp('table').getSelection()[0].picasa().getAt(0).set('newcomment',false);
            }
    	});
    },
    
    showDetailMap: function() {
    	this.getDetailMap().setMask({message: ' '});
    	//Retrieve comments for the image
    	Ext.util.JSONP.request({
            url: server+'location.php',
            callbackKey: 'callback',
            params: {
                username: username,
                password: password,
                photoid: this.getTable().getSelection()[0].picasa().getAt(0).get('id')
            },

            callback: function(result) {
            	Ext.getCmp('detailmap').bindMap(result);
            	Ext.getCmp('detailmap').setMask(false);
            	Ext.getCmp('detail').loadingmask = false;
            }
    	});
    },
    
    recordAudio: function(button) {
    	navigator.device.capture.captureAudio(
        	function(mediaFiles) {
            	var mediaFile = mediaFiles[mediaFiles.length-1];
            	
            	var params = new Object();
            	params.photoid = Ext.getCmp('table').getSelection()[0].get('picasaid');
            	
            	var ft = new FileTransfer(),
                	path = mediaFile.fullPath,
                	name = mediaFile.name;

            	ft.upload(path, "http://278978.webtest.goneo.de/upload.php",
	                function(result) {
	                    console.log(result);
	                    var newValue = "Audiobeschreibung..."
	                    Ext.getCmp('table').getSelection()[0].picasa().getAt(0).set('summary',newValue);
	                    Ext.getCmp('table').getSelection()[0].picasa().getAt(0).set('description',newValue);
	                    Ext.getCmp('table').getSelection()[0].picasa().getAt(0).summaryupdate = true;
	                },
	                function(error) {
	                    console.log('Error uploading file ' + path + ': ' + error.code);
	                },
	                { fileName: name, params: params }
                );   
            }, 
            function captureError(error) {
            	console.log(error);
            }
    	);
    },
    
    deleteAudio: function(button, event, eOpts) {
    	//Update store
    	this.getTable().getSelection()[0].picasa().getAt(0).set('summary','');
    	this.getTable().getSelection()[0].picasa().getAt(0).set('audio','');
    	this.getTable().getSelection()[0].picasa().getAt(0).summaryupdate = true;
    	
    	//Update UI
    	this.getDetailInfo().child('fieldset').setTitle('Bildbeschreibung:');
    	this.getDetailInfo().child('fieldset').remove(button.getParent().child('audio'),true);
    	this.getDetailInfo().child('fieldset').remove(button,true);
    	this.getDetailInfo().child('fieldset').setTitle('Bildbeschreibung:');
    	this.getDetailInfo().child('fieldset').add({
    		xtype: 'textareafield',
    		id: 'description',
    		name : 'description',
    		labelWidth: 0,
    	});
    },
    
    changeDescription: function(textfield, newValue, oldValue, eOpts ) {
    	//Update store
    	this.getTable().getSelection()[0].picasa().getAt(0).set('summary',newValue);
    	this.getTable().getSelection()[0].picasa().getAt(0).set('description',newValue);
    	this.getTable().getSelection()[0].picasa().getAt(0).summaryupdate = true;
    },
    
    addTag: function(button, event, eOpts) {
    	var tag = button.getParent().child('#newtag').getValue();
    	this.getDetailInfo().down('#taglist').getStore().add({name: tag});
    	button.getParent().child('#newtag').reset();
    	this.getTable().getSelection()[0].picasa().getAt(0).tagupdate = true;
    },
    
    addComment: function(button, event, eOpts) {
    	//Update UI
    	var comment = button.getParent().child('#newcomment').getValue();
    	this.getDetailComments().down('#commentlist').getStore().add({author: 'Ich', content: comment});
    	button.getParent().child('#newcomment').reset();
    	//Update Store
    	this.getTable().getSelection()[0].picasa().getAt(0).commentupdate = comment;
    },
    
    deleteTag: function(record) {
    	this.getDetailInfo().down('#taglist').getStore().remove(record);
    	this.getTable().getSelection()[0].picasa().getAt(0).tagupdate = true;
    },
    
    changeLocation: function(button) {
    	var address = button.getParent().child('#address').getValue();
    	var selected = this.getTable().getSelection()[0].picasa().getAt(0);
    	//Since GMaps API is needed UI and Store Update are made inside DetailMap
    	this.getDetailMap().updateLocation(selected, address);
    },
    
    deletePicture: function(button) {
		this.getDetail().hide();
    	Ext.Msg.confirm("Bild l&ouml;schen?", "Soll das Bild wirklich endg&uuml;ltig gel&ouml;scht werden?", 
    		function(btnId) {
    			if(btnId=='yes') {
    				var selected = Ext.getCmp('table').getSelection()[0];
    				//Update Picasa
    				Ext.util.JSONP.request({
    	                url: server+'delete.php',
    	                callbackKey: 'callback',
    	                params: {
    	                	username: username,
    	                	password: password,
    	                	photoid: selected.get('picasaid')
    	                },
    	                callback: function() {
    	                	//Update Store
    	                	Ext.getCmp('table').getStore().remove(selected);
    	                	selected.destroy();
    	                }
    	        	});
    			}
    		}
    	);
    },
    

    composeShareMail : function(button) {
    	var key = encodeURIComponent(albumlist);
		var msg = {
			subject : "Mein Photoalbum",
			bcc : "daniel.grosche@gmail.com", 
			body : "Du wurdest eingeladen Dir mein Photoalbum anzuschauen.\n\n"+
				"Klicke dazu einfach auf folgenden Link: http://tinyurl.com/7opro5c \n"+ // ah:http://tinyurl.com/6w9qemf sh: http://tinyurl.com/832zcd4
				"Oder schau Dir das Photoalbum direkt bei Picasa an: http://tinyurl.com/79eux4s \n\n"+ // ah:http://tinyurl.com/837o9kl sh: http://tinyurl.com/7ybxy62
				"Zum Kommentieren brauchst Du einen kostenlosen Picasa-Zugang, melde Dich dazu hier an: http://picasaweb.google.com/"
		};
		window.location = "mailto:?" + Ext.urlEncode(msg);
	},
	
	selectPhoto: function(button) {
		this.resetZoom();
		this.getMainview().getParent().setMask({message: ' '});
		
		Ext.Msg.show({
			    title : "Foto hinzuf&uuml;gen:",
			    msg : "Soll das Foto mit der Kamera aufgenommen oder aus der Galerie ausgew&auml;hlt werden?",
			    buttons : [
			        {iconMask: true, iconAlign: 'top', iconCls: 'camera', text: 'Kamera',    itemId: 'camera'},
			        {iconMask: true, iconAlign: 'top', iconCls: 'album',  text: 'Galerie',  itemId: 'album'},
			        {iconMask: true, iconAlign: 'top', iconCls: 'reply',  text: unescape('Zur%FCck'), itemId: 'cancel'}
			    ],
			    fn : function(btn) {
			        if(btn == 'camera') {
			        	this.createPhoto(navigator.camera.PictureSourceType.CAMERA);
			        } else if(btn == 'album'){
			        	this.createPhoto(navigator.camera.PictureSourceType.PHOTOLIBRARY);
			        } else {
			        	Ext.getCmp('mainview').getParent().setMask({xtype: 'mask'});
						Ext.getCmp('mainview').getParent().unmask();
			        }
			    },
			    scope: this
		});
	},
	
	createPhoto: function(sourceType) {
		navigator.camera.getPicture(
			    function(imgdata) {
			    	/**/
			    	Ext.Cors.request({
						url: server+"create.php",
						params: {
							imgdata: imgdata,
							username: username,
							password: password,
						},
						method: 'POST',
						callback: function(options,success,response) {
							var result = Ext.decode(response.responseText);
							Ext.getCmp('mainview').getParent().setMask({xtype: 'mask'});
							Ext.getCmp('mainview').getParent().unmask();
							Ext.getCmp('table').setMask({xtype: 'mask',cls: 'gridmask'});
				    		Ext.getCmp('mainview').getScrollable().getScroller().setDisabled(true);
				    		Ext.getCmp('table').element.on('tap', function(event) {
				    			var scrollX = Ext.getCmp('mainview').getScrollable().getScroller().position.x;
				    			var scrollY = Ext.getCmp('mainview').getScrollable().getScroller().position.y;
				    			var bounds = getGridBounds([event.touch.pageX+scrollX,event.touch.pageY+scrollY,
			    				                            result.width,result.height]);
				    			var closest = getClosestAvailable(bounds,spawnGrid);
			    				if(closest && closest.length==2) {
			    					bounds[0]=closest[0]; bounds[1]=closest[1];
			    					spawnGrid = setAvailableGrid(bounds,spawnGrid,false);
			    					var newImage = Ext.create('Photoalbum.model.Image', {'picasaid': result.id, 'top': (bounds[1]*150)+300,'left': (bounds[0]*150)+300});
			            			var imagePicasa = newImage.picasa();
			                		imagePicasa.add(result);
			                		imagePicasa.sync();
			                		Ext.getCmp('table').getStore().add(newImage);
			    				}
		                		Ext.getCmp('mainview').getScrollable().getScroller().setDisabled(false);
		                		Ext.getCmp('table').setMask({xtype: 'mask'});
		                		Ext.getCmp('table').unmask();
				    		}, this, {single: true});
						}
					});/**/
			    	
			    	/*
				    var options = new FileUploadOptions();
					var params = new Object();
					params.username = username;
					params.password = password;

					options.params = params;
					
					var ft = new FileTransfer();
					ft.upload(imgdata,"http://www.malermeister-jaenicke.de/upload.php",
						function(r) {
							console.log("Code = " + r.responseCode);
							console.log("Response = " + r.response);
							console.log("Sent = " + r.bytesSent);
						},
						function(error) {
							alert("An error has occurred: Code = " = error.code);
						}, 
					options);
					/**/
				},
				function(message) {
					Ext.getCmp('mainview').getParent().setMask({xtype: 'mask'});
					Ext.getCmp('mainview').getParent().unmask();
				},
				{ quality: 50, 
	              destinationType: navigator.camera.DestinationType.DATA_URL,
	              sourceType: sourceType }
			);
	},
	
	resetZoom: function() {
		this.getTable().element.dom.firstChild.style.webkitTransform ="";
		scale = 1; startscale = 1; relX = 0; relY = 0; transX = 0; transY = 0; 
	}
    
});